/*
 * Decompiled with CFR 0.152.
 */
package com.burotester.InstallTester;

import com.xlnt.utils.win32.LinkWin32;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class InstallCDLJAVA
extends JFrame
implements ActionListener {
    JButton verder = new JButton("Volgende");
    JButton annuleer = new JButton("Annuleer  ");
    JButton terug = new JButton("Terug");
    JButton zoekDir = new JButton("...");
    JTextField textDir = new JTextField("c:/cdljava", 40);
    Label status = new Label(" ");
    ButtonGroup group = new ButtonGroup();
    JCheckBox bladIcon = new JCheckBox("<html>Starticoon en Icoon voor handleiding op bureaublad</html>", true);
    JCheckBox menuIcon = new JCheckBox("<html>Starticoon en Icoon voor handleiding in Startmenu</html>", true);
    JRadioButton yes = new JRadioButton("<html>Ik, accepteer de licentieovereenkomst</html>");
    JRadioButton no = new JRadioButton("<html>Ik, accepteer de licentieovereenkomst <b>niet</b></html>", true);
    JPanel startPanel = new JPanel(new BorderLayout());
    JPanel licPanel = new JPanel(new BorderLayout());
    JPanel instPanel = new JPanel(new BorderLayout());
    JPanel knopPanel = new JPanel(new BorderLayout());
    ZipInputStream dis;
    FileWriter log;

    public InstallCDLJAVA() {
        this.init();
        this.checkversie();
    }

    public static void main(String[] args) {
        new InstallCDLJAVA();
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource().equals(this.verder)) {
            if (this.startPanel.isShowing()) {
                this.terug.setVisible(true);
                this.getContentPane().remove(this.startPanel);
                this.getContentPane().add((Component)this.licPanel, "Center");
            } else if (this.licPanel.isShowing()) {
                if (!this.yes.isSelected()) {
                    this.warn("<html>Accepteer de Licentieovereenkomst<br>of Annuleer</html>", "Accepteer de Licentieovereenkomst");
                    return;
                }
                this.getContentPane().remove(this.licPanel);
                this.getContentPane().add((Component)this.instPanel, "Center");
            } else if (this.instPanel.isShowing()) {
                this.do_InstallCDLJAVA();
            }
            this.getContentPane().validate();
            this.getContentPane().repaint();
        } else if (ae.getSource().equals(this.annuleer)) {
            Object[] keuze = new Object[]{"Ja", "Nee"};
            int optionPane = JOptionPane.showOptionDialog(this, "Wilt u de installatie stoppen?", "Zeker weten?", 0, 3, null, keuze, keuze[0]);
            if (optionPane == 0) {
                System.exit(0);
            }
        } else if (ae.getSource().equals(this.terug)) {
            if (this.licPanel.isShowing()) {
                this.terug.setVisible(false);
                this.getContentPane().remove(this.licPanel);
                this.getContentPane().add((Component)this.startPanel, "Center");
            } else if (this.instPanel.isShowing()) {
                this.getContentPane().remove(this.instPanel);
                this.getContentPane().add((Component)this.licPanel, "Center");
            }
            this.getContentPane().validate();
            this.getContentPane().repaint();
        } else if (ae.getSource().equals(this.zoekDir)) {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(1);
            int returnVal = fc.showSaveDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                this.textDir.setText(file.getAbsolutePath());
            }
        }
    }

    void checkversie() {
        if (!System.getProperty("java.version").startsWith("1.5") && !System.getProperty("java.version").startsWith("1.6")) {
            String mes = "Java versie is " + System.getProperty("java.version");
            mes = mes + "\nUpdaten naar versie 1.6 is zinvol voor een betere prestatie van CDLJava\nUpdate de JRE van internet bij \nhttp://java.sun.com/getjava/index.html";
            this.warn(mes, "JRE Check");
        }
    }

    void createLinks(String doelPad) {
        try {
            System.load(this.textDir.getText() + "/jars/Win32Util.dll");
            LinkWin32 lnk = new LinkWin32();
            lnk.createLink("\"" + System.getProperty("java.home") + "/bin/javaw.exe\"", doelPad + "/Start CDLJava.lnk", "Start CDLJava", "-cp .;jars/cdljava.jar com.burotester.cdljava.cdljava", this.textDir.getText(), this.textDir.getText() + "/r.ico", 0);
            lnk.createLink(this.textDir.getText() + "/html/nl/cdl/index.html", doelPad + "/Handleiding CDLJava.lnk", "Handleiding CDLjava", "", this.textDir.getText(), this.textDir.getText() + "/r.ico", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void do_InstallCDLJAVA() {
        try {
            this.haalbestanden();
            if (this.bladIcon.isSelected()) {
                File fl = new File(System.getProperty("user.home") + "/Bureaublad");
                if (!fl.exists()) {
                    fl = new File(System.getProperty("user.home") + "/Desktop");
                }
                this.createLinks(fl.getAbsolutePath());
            }
            if (this.menuIcon.isSelected()) {
                String menu = System.getProperty("user.home") + "/Menu Start";
                this.createLinks(menu);
            }
            this.log.close();
            this.warn("Installatie voltooid", "Klaar");
            System.exit(0);
        }
        catch (Exception e) {
            this.warn(e.getMessage(), "Fout!");
            System.out.println(e.getMessage());
            try {
                this.log.write("\n" + e.getMessage());
                this.log.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        finally {
            try {
                if (this.dis != null) {
                    this.dis.close();
                }
            }
            catch (IOException ioe2) {
                ioe2.printStackTrace();
            }
        }
        System.exit(0);
    }

    private String extract(String filename_) throws IOException {
        int r;
        File me = new File(System.getProperty("java.class.path"));
        File fln = new File(filename_);
        File tmpFile = File.createTempFile(fln.getName(), null);
        tmpFile.deleteOnExit();
        JarFile jar = new JarFile(me);
        InputStream in = jar.getInputStream(jar.getEntry(filename_));
        FileOutputStream out = new FileOutputStream(tmpFile);
        byte[] buf = new byte[1024];
        while ((r = in.read(buf, 0, buf.length)) != -1) {
            out.write(buf, 0, r);
        }
        out.close();
        in.close();
        jar.close();
        return tmpFile.getAbsolutePath();
    }

    void haalbestanden() throws Exception {
        File fl;
        File des2 = new File(this.textDir.getText());
        if (!des2.getAbsolutePath().endsWith("cdljava")) {
            String fln = this.textDir.getText();
            if (fln.endsWith("\\") || fln.endsWith("/")) {
                fln = fln.substring(0, fln.length() - 1);
            }
            des2 = new File(fln + "/cdljava");
            this.textDir.setText(des2.getAbsolutePath());
        }
        if (!des2.exists()) {
            this.warn("Map " + des2.toString() + " wordt gemaakt!", "Map Maken");
            if (!des2.mkdirs()) {
                this.warn("Fout bij maken van map\n" + des2.getAbsolutePath() + "\nControleer pad", "Fout bij maken van map");
                return;
            }
        }
        this.log = new FileWriter(des2.getAbsolutePath() + "/installatieCDLJava.log", true);
        DateFormat df = DateFormat.getDateTimeInstance(2, 3, Locale.getDefault());
        this.log.write(des2.getAbsolutePath() + "\n\n");
        this.log.write("\n\nInstallatie: " + df.format(new Date()) + "\n\n");
        this.dis = new ZipInputStream(new FileInputStream(new File(System.getProperty("java.class.path"))));
        this.log.write("\n---Bestanden ge\u00efnstalleerd---\n");
        ZipEntry zipentry = this.dis.getNextEntry();
        while (zipentry != null) {
            if (zipentry.toString().indexOf("META-INF") == -1 && zipentry.toString().indexOf("InstallTester") == -1) {
                if (zipentry.isDirectory()) {
                    File dir = new File(des2, zipentry.toString());
                    dir.mkdirs();
                } else {
                    try {
                        fl = new File(des2, zipentry.toString());
                        this.log.write("\n" + zipentry.toString());
                        this.status.setText("Kopi\u00eber bestand: " + zipentry.toString());
                        this.status.validate();
                        this.status.repaint();
                        FileOutputStream out = new FileOutputStream(fl);
                        byte[] buf = new byte[(int)zipentry.getSize()];
                        int c = 0;
                        while ((c = this.dis.read(buf)) > 0) {
                            out.write(buf, 0, c);
                        }
                        out.close();
                    }
                    catch (Exception ex2) {
                        this.log.write("\t" + ex2.getMessage());
                        System.out.println("\t" + ex2.getMessage());
                    }
                }
            }
            zipentry = this.dis.getNextEntry();
        }
        this.dis.close();
        fl = new File(des2, "com.burotester.util");
        fl.delete();
    }

    void init() {
        try {
            this.setDefaultCloseOperation(2);
            this.setSize(640, 480);
            this.setTitle("Installeer CDLjava");
            this.verder.addActionListener(this);
            this.terug.addActionListener(this);
            this.annuleer.addActionListener(this);
            this.zoekDir.addActionListener(this);
            JPanel hulpPanel = new JPanel();
            hulpPanel.setBackground(Color.LIGHT_GRAY);
            hulpPanel.add(this.terug);
            hulpPanel.add(this.verder);
            hulpPanel.add(this.annuleer);
            this.knopPanel.add((Component)hulpPanel, "East");
            this.knopPanel.setBackground(Color.LIGHT_GRAY);
            String imgFile = this.extract("pics/tester.gif");
            this.startPanel.setBackground(Color.LIGHT_GRAY);
            this.startPanel.add((Component)new JLabel("<html><img src=file:" + imgFile + "></html>"), "West");
            this.startPanel.add((Component)new JLabel(this.leesZip("InstallatieWelkom.html").toString()), "East");
            this.licPanel.add((Component)new JLabel("<html><b>Licentieovereenkomst<b><br>Voorwaarden en condities van het gebruik van CDLJava.<hr>Lees de licentieovereenkomst aandachtig door voor u doorgaat met de installatie.</html>", 0), "North");
            JPanel radioknoppen = new JPanel(new BorderLayout());
            this.group.add(this.yes);
            this.group.add(this.no);
            radioknoppen.add((Component)this.yes, "North");
            radioknoppen.add((Component)this.no, "South");
            this.licPanel.add((Component)radioknoppen, "South");
            this.licPanel.setBackground(Color.LIGHT_GRAY);
            JTextArea tx = new JTextArea(this.leesZip("help/nl/agree").toString());
            this.licPanel.add((Component)new JScrollPane(tx), "Center");
            this.instPanel.setBackground(Color.LIGHT_GRAY);
            this.instPanel.add((Component)new JLabel("<html>Controleer de onderstaande Instellingen.</html>", 0), "North");
            JPanel checkPanel = new JPanel(new BorderLayout());
            checkPanel.add((Component)this.menuIcon, "North");
            checkPanel.add((Component)this.bladIcon, "South");
            JPanel dirPanel = new JPanel();
            dirPanel.add(new JLabel("Installatiemap: "));
            dirPanel.add(this.textDir);
            dirPanel.add(this.zoekDir);
            JPanel centerPanel = new JPanel(new BorderLayout());
            centerPanel.setBackground(Color.LIGHT_GRAY);
            centerPanel.add((Component)checkPanel, "North");
            centerPanel.add((Component)dirPanel, "Center");
            JPanel statusPanel = new JPanel(new BorderLayout());
            statusPanel.add((Component)new JLabel("<html>Indien akkoord: start de installatie met de de knop Volgende<br>Na installatie Start u het programma, moet u registreren<br>en de opties Instellen,<br><br>Zie ook de handleiding onder menu Help|Help</html>"), "North");
            statusPanel.add((Component)this.status, "South");
            centerPanel.add((Component)statusPanel, "South");
            this.instPanel.add((Component)centerPanel, "Center");
            this.getContentPane().add((Component)this.startPanel, "Center");
            this.getContentPane().add((Component)this.knopPanel, "South");
            this.terug.setVisible(false);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setBounds(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2, this.getSize().width, this.getSize().height);
            this.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    StringBuffer leesZip(String fln) {
        StringBuffer sb = new StringBuffer();
        try {
            JarFile jar = new JarFile(new File(System.getProperty("java.class.path")));
            InputStream in = jar.getInputStream(jar.getEntry(fln));
            byte[] buf = new byte[2048];
            int c = 0;
            while ((c = in.read(buf)) > 0) {
                sb.append(new String(buf, 0, c));
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return sb;
    }

    void warn(String s, String t) {
        JOptionPane.showMessageDialog(this, s, t, -1);
    }
}

